from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecureClusterAddressEndPoint')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecureClusterAddressEndPoint");
  exportedObject.put("roleName", "WebSphereSecureClusterAddressEndPoint");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureclusteraddressendpoint.port", objid, "port","SecureClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureclusteraddressendpoint.name", objid, "name","SecureClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureclusteraddressendpoint.enabled", objid, "enabled","SecureClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureclusteraddressendpoint.host", objid, "host","SecureClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureclusteraddressendpoint.stashfile", objid, "stashfile","SecureClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureclusteraddressendpoint.keyring", objid, "keyring","SecureClusterAddressEndPoint");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.secureclusteraddressendpoint.certificatelabel", objid, "certificateLabel","SecureClusterAddressEndPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"SecureClusterAddressEndPoint");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecureClusterAddressEndPoint');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecureClusterAddressEndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecureClusterAddressEndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "port", roleProperties.optString("websphere.secureclusteraddressendpoint.port", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.secureclusteraddressendpoint.name", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.secureclusteraddressendpoint.enabled", None));
  Util.addIfNotNone(properties, "host", roleProperties.optString("websphere.secureclusteraddressendpoint.host", None));
  Util.addIfNotNone(properties, "stashfile", roleProperties.optString("websphere.secureclusteraddressendpoint.stashfile", None));
  Util.addIfNotNone(properties, "keyring", roleProperties.optString("websphere.secureclusteraddressendpoint.keyring", None));
  Util.addIfNotNone(properties, "certificateLabel", roleProperties.optString("websphere.secureclusteraddressendpoint.certificatelabel", None));
  print "Creating SecureClusterAddressEndPoint with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecureClusterAddressEndPoint", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SecureClusterAddressEndPoint');

def update(objid,jsonobject):
  Util.pushPathElement('SecureClusterAddressEndPoint')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecureClusterAddressEndPoint resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureclusteraddressendpoint.port", None), "port","SecureClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureclusteraddressendpoint.name", None), "name","SecureClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureclusteraddressendpoint.enabled", None), "enabled","SecureClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureclusteraddressendpoint.host", None), "host","SecureClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureclusteraddressendpoint.stashfile", None), "stashfile","SecureClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureclusteraddressendpoint.keyring", None), "keyring","SecureClusterAddressEndPoint");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.secureclusteraddressendpoint.certificatelabel", None), "certificateLabel","SecureClusterAddressEndPoint");
  if len(atts) != 0:
    print "Modifying SecureClusterAddressEndPoint with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecureClusterAddressEndPoint configuration up to date.";

  Property.removeProperties(objid, 'properties',"SecureClusterAddressEndPoint");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('SecureClusterAddressEndPoint');
