from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.serviceclass.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'ServiceClass');

  containmentpath = "%(parentconpath)sServiceClass:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('ServiceClass')

  name = Util.getRequiredAttribute(objid, "name", 'ServiceClass');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServiceClass");
  exportedObject.put("roleName", "WebSphereServiceClass");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serviceclass.name", objid, "name","ServiceClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serviceclass.description", objid, "description","ServiceClass");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServiceClass');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.serviceclass.name"):
    raise Exception("Resource role properties does not contain websphere.serviceclass.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ServiceClass on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('ServiceClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.serviceclass.name"):
    raise Exception("Resource role properties does not contain websphere.serviceclass.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.serviceclass.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.serviceclass.description", None));
  print "Creating ServiceClass with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServiceClass", parentid, properties);
  Util.popPathElement('ServiceClass');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ServiceClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.serviceclass.name"):
    raise Exception("Resource role properties does not contain websphere.serviceclass.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serviceclass.name", None), "name","ServiceClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serviceclass.description", None), "description","ServiceClass");
  if len(atts) != 0:
    print "Modifying ServiceClass with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServiceClass configuration up to date.";

  Util.popPathElement('ServiceClass');
