from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TimeMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTimeMapping");
  exportedObject.put("roleName", "WebSphereTimeMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timemapping.endtime", objid, "endTime","TimeMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timemapping.starttime", objid, "startTime","TimeMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timemapping.action", objid, "action","TimeMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TimeMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TimeMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("TimeMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "endTime", roleProperties.optString("websphere.timemapping.endtime", None));
  Util.addIfNotNone(properties, "startTime", roleProperties.optString("websphere.timemapping.starttime", None));
  Util.addIfNotNone(properties, "action", roleProperties.optString("websphere.timemapping.action", None));
  print "Creating TimeMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TimeMapping", parentid, properties);
  Util.popPathElement('TimeMapping');

def update(objid,jsonobject):
  Util.pushPathElement('TimeMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("TimeMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timemapping.endtime", None), "endTime","TimeMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timemapping.starttime", None), "startTime","TimeMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timemapping.action", None), "action","TimeMapping");
  if len(atts) != 0:
    print "Modifying TimeMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TimeMapping configuration up to date.";

  Util.popPathElement('TimeMapping');
