from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TransactionClassModule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransactionClassModule");
  exportedObject.put("roleName", "WebSphereTransactionClassModule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionclassmodule.workfactor", objid, "workFactor","TransactionClassModule");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.transactionclassmodule.uris", objid, "URIs","TransactionClassModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionclassmodule.id", objid, "id","TransactionClassModule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TransactionClassModule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TransactionClassModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransactionClassModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "workFactor", roleProperties.optString("websphere.transactionclassmodule.workfactor", None));
  Util.addPathProperty(properties, "URIs", roleProperties.optString("websphere.transactionclassmodule.uris", None));
  Util.addIfNotNone(properties, "id", roleProperties.optString("websphere.transactionclassmodule.id", None));
  print "Creating TransactionClassModule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TransactionClassModule", parentid, properties);
  Util.popPathElement('TransactionClassModule');

def update(objid,jsonobject):
  Util.pushPathElement('TransactionClassModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransactionClassModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionclassmodule.workfactor", None), "workFactor","TransactionClassModule");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionclassmodule.uris", None), "URIs","TransactionClassModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionclassmodule.id", None), "id","TransactionClassModule");
  if len(atts) != 0:
    print "Modifying TransactionClassModule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TransactionClassModule configuration up to date.";

  Util.popPathElement('TransactionClassModule');
