from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from DeploymentTargetMapping import DeploymentTargetMapping
from Property import Property
from Classloader import Classloader

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WebModuleDeployment')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWebModuleDeployment");
  exportedObject.put("roleName", "WebSphereWebModuleDeployment");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduledeployment.name", objid, "name","WebModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduledeployment.startingweight", objid, "startingWeight","WebModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduledeployment.uri", objid, "uri","WebModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduledeployment.deploymentid", objid, "deploymentId","WebModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduledeployment.containsejbcontent", objid, "containsEJBContent","WebModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduledeployment.altdd", objid, "altDD","WebModuleDeployment");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduledeployment.classloadermode", objid, "classloaderMode","WebModuleDeployment");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"WebModuleDeployment");
  i = 0;
  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"WebModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      returndict = Util.createTypeFolder(respath, "DeploymentTargetMapping", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DeploymentTargetMapping._export(targetmapping, currespath, "DeploymentTargetMapping%s" % i));
      i = i + 1;
      
  classloader = Util.getRequiredAttribute(objid, 'classloader',"WebModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    returndict = Util.createTypeFolder(respath, "Classloader", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, Classloader._export(classloader, currespath, "Classloader"));     
      
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WebModuleDeployment');
  return result;

def create(parentid, jsonobject):
  Util.pushPathElement('WebModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.webmoduledeployment.name", ""));
  Util.addIfNotNone(properties, "startingWeight", roleProperties.optString("websphere.webmoduledeployment.startingweight", None));
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.webmoduledeployment.uri", None));
  Util.addIfNotNone(properties, "deploymentId", roleProperties.optString("websphere.webmoduledeployment.deploymentid", None));
  Util.addIfNotNone(properties, "containsEJBContent", roleProperties.optString("websphere.webmoduledeployment.containsejbcontent", "0"));
  Util.addIfNotNone(properties, "altDD", roleProperties.optString("websphere.webmoduledeployment.altdd", None));
  Util.addIfNotNone(properties, "classloaderMode", roleProperties.optString("websphere.webmoduledeployment.classloadermode", None));
  print "Creating WebModuleDeployment with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WebModuleDeployment", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WebModuleDeployment');

def update(objid,jsonobject):
  Util.pushPathElement('WebModuleDeployment')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebModuleDeployment resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduledeployment.name", ""), "name","WebModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduledeployment.startingweight", None), "startingWeight","WebModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduledeployment.uri", None), "uri","WebModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduledeployment.deploymentid", None), "deploymentId","WebModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduledeployment.containsejbcontent", "0"), "containsEJBContent","WebModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduledeployment.altdd", None), "altDD","WebModuleDeployment");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduledeployment.classloadermode", None), "classloaderMode","WebModuleDeployment");
  if len(atts) != 0:
    print "Modifying WebModuleDeployment with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WebModuleDeployment configuration up to date.";

  targetmappings = Util.parseConfigIdListAttribute(objid, 'targetMappings',"WebModuleDeployment");
  for targetmapping in targetmappings:
    if len(targetmapping) > 0:
      Util.remove(targetmapping);

  classloader = Util.getRequiredAttribute(objid, 'classloader',"WebModuleDeployment");
  if classloader is not None and len(classloader) > 0:
    Util.remove(classloader);           
      
  Property.removeProperties(objid, 'properties',"WebModuleDeployment");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDeploymentTargetMapping":
        DeploymentTargetMapping.create(objid, curjsonobject);
      elif currole == "WebSphereClassloader":
        Classloader.create(objid, curjsonobject);    
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WebModuleDeployment');
