from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WorkloadCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWorkloadCondition");
  exportedObject.put("roleName", "WebSphereWorkloadCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workloadcondition.totalrequests", objid, "totalRequests","WorkloadCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workloadcondition.name", objid, "name","WorkloadCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.workloadcondition.conditionexpr", objid, "conditionExpr","WorkloadCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WorkloadCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WorkloadCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkloadCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "totalRequests", roleProperties.optString("websphere.workloadcondition.totalrequests", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.workloadcondition.name", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.workloadcondition.conditionexpr", None));
  print "Creating WorkloadCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WorkloadCondition", parentid, properties);
  Util.popPathElement('WorkloadCondition');

def update(objid,jsonobject):
  Util.pushPathElement('WorkloadCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("WorkloadCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workloadcondition.totalrequests", None), "totalRequests","WorkloadCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workloadcondition.name", None), "name","WorkloadCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.workloadcondition.conditionexpr", None), "conditionExpr","WorkloadCondition");
  if len(atts) != 0:
    print "Modifying WorkloadCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WorkloadCondition configuration up to date.";

  Util.popPathElement('WorkloadCondition');
