from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuditSpecification')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuditSpecification");
  exportedObject.put("roleName", "WebSphereAuditSpecification");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditspecification.name", objid, "name","AuditSpecification");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditspecification.enabled", objid, "enabled","AuditSpecification");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.auditspecification.outcome", objid, "outcome","AuditSpecification");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.auditspecification.event", objid, "event","AuditSpecification");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuditSpecification');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuditSpecification')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditSpecification resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.auditspecification.name", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.auditspecification.enabled", None));
  Util.addPathProperty(properties, "outcome", roleProperties.optString("websphere.auditspecification.outcome", None));
  Util.addPathProperty(properties, "event", roleProperties.optString("websphere.auditspecification.event", None));
  print "Creating AuditSpecification with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuditSpecification", parentid, properties);
  Util.popPathElement('AuditSpecification');

def update(objid,jsonobject):
  Util.pushPathElement('AuditSpecification')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditSpecification resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditspecification.name", None), "name","AuditSpecification");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditspecification.enabled", None), "enabled","AuditSpecification");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.auditspecification.outcome", None), "outcome","AuditSpecification");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.auditspecification.event", None), "event","AuditSpecification");
  if len(atts) != 0:
    print "Modifying AuditSpecification with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuditSpecification configuration up to date.";

  Util.popPathElement('AuditSpecification');
