from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.healthclass.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'HealthClass');

  containmentpath = "%(parentconpath)sHealthClass:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('HealthClass')

  name = Util.getRequiredAttribute(objid, "name", 'HealthClass');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereHealthClass");
  exportedObject.put("roleName", "WebSphereHealthClass");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthclass.reactionmode", objid, "reactionMode","HealthClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthclass.name", objid, "name","HealthClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.healthclass.description", objid, "description","HealthClass");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('HealthClass');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.healthclass.name"):
    raise Exception("Resource role properties does not contain websphere.healthclass.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create HealthClass on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('HealthClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.healthclass.name"):
    raise Exception("Resource role properties does not contain websphere.healthclass.name!");

  properties = [];
  Util.addIfNotNone(properties, "reactionMode", roleProperties.optString("websphere.healthclass.reactionmode", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.healthclass.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.healthclass.description", None));
  print "Creating HealthClass with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("HealthClass", parentid, properties);
  Util.popPathElement('HealthClass');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('HealthClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("HealthClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.healthclass.name"):
    raise Exception("Resource role properties does not contain websphere.healthclass.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthclass.reactionmode", None), "reactionMode","HealthClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthclass.name", None), "name","HealthClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.healthclass.description", None), "description","HealthClass");
  if len(atts) != 0:
    print "Modifying HealthClass with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "HealthClass configuration up to date.";

  Util.popPathElement('HealthClass');
