from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBFilestore')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBFilestore");
  exportedObject.put("roleName", "WebSphereSIBFilestore");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.uuid", objid, "uuid","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.unlimitedpermanentstoresize", objid, "unlimitedPermanentStoreSize","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.minpermanentstoresize", objid, "minPermanentStoreSize","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.maxtemporarystoresize", objid, "maxTemporaryStoreSize","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.logsize", objid, "logSize","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.maxpermanentstoresize", objid, "maxPermanentStoreSize","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.permanentstoredirectory", objid, "permanentStoreDirectory","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.temporarystoredirectory", objid, "temporaryStoreDirectory","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.unlimitedtemporarystoresize", objid, "unlimitedTemporaryStoreSize","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.mintemporarystoresize", objid, "minTemporaryStoreSize","SIBFilestore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibfilestore.logdirectory", objid, "logDirectory","SIBFilestore");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBFilestore');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBFilestore')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBFilestore resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibfilestore.uuid", None));
  Util.addIfNotNone(properties, "unlimitedPermanentStoreSize", roleProperties.optString("websphere.sibfilestore.unlimitedpermanentstoresize", None));
  Util.addIfNotNone(properties, "minPermanentStoreSize", roleProperties.optString("websphere.sibfilestore.minpermanentstoresize", None));
  Util.addIfNotNone(properties, "maxTemporaryStoreSize", roleProperties.optString("websphere.sibfilestore.maxtemporarystoresize", None));
  Util.addIfNotNone(properties, "logSize", roleProperties.optString("websphere.sibfilestore.logsize", None));
  Util.addIfNotNone(properties, "maxPermanentStoreSize", roleProperties.optString("websphere.sibfilestore.maxpermanentstoresize", None));
  Util.addIfNotNone(properties, "permanentStoreDirectory", roleProperties.optString("websphere.sibfilestore.permanentstoredirectory", None));
  Util.addIfNotNone(properties, "temporaryStoreDirectory", roleProperties.optString("websphere.sibfilestore.temporarystoredirectory", None));
  Util.addIfNotNone(properties, "unlimitedTemporaryStoreSize", roleProperties.optString("websphere.sibfilestore.unlimitedtemporarystoresize", None));
  Util.addIfNotNone(properties, "minTemporaryStoreSize", roleProperties.optString("websphere.sibfilestore.mintemporarystoresize", None));
  Util.addIfNotNone(properties, "logDirectory", roleProperties.optString("websphere.sibfilestore.logdirectory", None));
  print "Creating SIBFilestore with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBFilestore", parentid, properties);
  Util.popPathElement('SIBFilestore');

def update(objid,jsonobject):
  Util.pushPathElement('SIBFilestore')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBFilestore resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.uuid", None), "uuid","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.unlimitedpermanentstoresize", None), "unlimitedPermanentStoreSize","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.minpermanentstoresize", None), "minPermanentStoreSize","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.maxtemporarystoresize", None), "maxTemporaryStoreSize","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.logsize", None), "logSize","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.maxpermanentstoresize", None), "maxPermanentStoreSize","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.permanentstoredirectory", None), "permanentStoreDirectory","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.temporarystoredirectory", None), "temporaryStoreDirectory","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.unlimitedtemporarystoresize", None), "unlimitedTemporaryStoreSize","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.mintemporarystoresize", None), "minTemporaryStoreSize","SIBFilestore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibfilestore.logdirectory", None), "logDirectory","SIBFilestore");
  if len(atts) != 0:
    print "Modifying SIBFilestore with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBFilestore configuration up to date.";

  Util.popPathElement('SIBFilestore');
