from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.timermanagerinfo.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'TimerManagerInfo');

  containmentpath = "%(parentconpath)sTimerManagerInfo:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('TimerManagerInfo')

  name = Util.getRequiredAttribute(objid, "name", 'TimerManagerInfo');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTimerManagerInfo");
  exportedObject.put("roleName", "WebSphereTimerManagerInfo");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerinfo.name", objid, "name","TimerManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerinfo.category", objid, "category","TimerManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerinfo.deftranclass", objid, "defTranClass","TimerManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerinfo.providertype", objid, "providerType","TimerManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerinfo.numalarmthreads", objid, "numAlarmThreads","TimerManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerinfo.jndiname", objid, "jndiName","TimerManagerInfo");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.timermanagerinfo.servicenames", objid, "serviceNames","TimerManagerInfo");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.timermanagerinfo.description", objid, "description","TimerManagerInfo");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TimerManagerInfo');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("TimerManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.timermanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.timermanagerinfo.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create TimerManagerInfo on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('TimerManagerInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("TimerManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.timermanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.timermanagerinfo.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.timermanagerinfo.name", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.timermanagerinfo.category", None));
  Util.addIfNotNone(properties, "defTranClass", roleProperties.optString("websphere.timermanagerinfo.deftranclass", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.timermanagerinfo.providertype", None));
  Util.addIfNotNone(properties, "numAlarmThreads", roleProperties.optString("websphere.timermanagerinfo.numalarmthreads", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.timermanagerinfo.jndiname", None));
  Util.addPathProperty(properties, "serviceNames", roleProperties.optString("websphere.timermanagerinfo.servicenames", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.timermanagerinfo.description", None));
  print "Creating TimerManagerInfo with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TimerManagerInfo", parentid, properties);
  Util.popPathElement('TimerManagerInfo');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('TimerManagerInfo')
  if not jsonobject.has("roleProperties"):
    raise Exception("TimerManagerInfo resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.timermanagerinfo.name"):
    raise Exception("Resource role properties does not contain websphere.timermanagerinfo.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.name", None), "name","TimerManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.category", None), "category","TimerManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.deftranclass", None), "defTranClass","TimerManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.providertype", None), "providerType","TimerManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.numalarmthreads", None), "numAlarmThreads","TimerManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.jndiname", None), "jndiName","TimerManagerInfo");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.servicenames", None), "serviceNames","TimerManagerInfo");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.timermanagerinfo.description", None), "description","TimerManagerInfo");
  if len(atts) != 0:
    print "Modifying TimerManagerInfo with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TimerManagerInfo configuration up to date.";

  Util.popPathElement('TimerManagerInfo');
