from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('VisualizationDataLog')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereVisualizationDataLog");
  exportedObject.put("roleName", "WebSphereVisualizationDataLog");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdatalog.filelocation", objid, "fileLocation","VisualizationDataLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdatalog.timestampformat", objid, "timestampFormat","VisualizationDataLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdatalog.rolloversize", objid, "rolloverSize","VisualizationDataLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdatalog.writeintervalunits", objid, "writeIntervalUnits","VisualizationDataLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdatalog.maxnumberofhistoriclogs", objid, "maxNumberOfHistoricLogs","VisualizationDataLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdatalog.transformaction", objid, "transformAction","VisualizationDataLog");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.visualizationdatalog.writeinterval", objid, "writeInterval","VisualizationDataLog");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('VisualizationDataLog');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('VisualizationDataLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("VisualizationDataLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "fileLocation", roleProperties.optString("websphere.visualizationdatalog.filelocation", None));
  Util.addIfNotNone(properties, "timestampFormat", roleProperties.optString("websphere.visualizationdatalog.timestampformat", None));
  Util.addIfNotNone(properties, "rolloverSize", roleProperties.optString("websphere.visualizationdatalog.rolloversize", None));
  Util.addIfNotNone(properties, "writeIntervalUnits", roleProperties.optString("websphere.visualizationdatalog.writeintervalunits", None));
  Util.addIfNotNone(properties, "maxNumberOfHistoricLogs", roleProperties.optString("websphere.visualizationdatalog.maxnumberofhistoriclogs", None));
  Util.addIfNotNone(properties, "transformAction", roleProperties.optString("websphere.visualizationdatalog.transformaction", None));
  Util.addIfNotNone(properties, "writeInterval", roleProperties.optString("websphere.visualizationdatalog.writeinterval", None));
  print "Creating VisualizationDataLog with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("VisualizationDataLog", parentid, properties);
  Util.popPathElement('VisualizationDataLog');

def update(objid,jsonobject):
  Util.pushPathElement('VisualizationDataLog')
  if not jsonobject.has("roleProperties"):
    raise Exception("VisualizationDataLog resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdatalog.filelocation", None), "fileLocation","VisualizationDataLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdatalog.timestampformat", None), "timestampFormat","VisualizationDataLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdatalog.rolloversize", None), "rolloverSize","VisualizationDataLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdatalog.writeintervalunits", None), "writeIntervalUnits","VisualizationDataLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdatalog.maxnumberofhistoriclogs", None), "maxNumberOfHistoricLogs","VisualizationDataLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdatalog.transformaction", None), "transformAction","VisualizationDataLog");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.visualizationdatalog.writeinterval", None), "writeInterval","VisualizationDataLog");
  if len(atts) != 0:
    print "Modifying VisualizationDataLog with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "VisualizationDataLog configuration up to date.";

  Util.popPathElement('VisualizationDataLog');
