from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from AuditSpecificationRef import AuditSpecificationRef
from AuditServiceProviderRef import AuditServiceProviderRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuditEventFactory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuditEventFactory");
  exportedObject.put("roleName", "WebSphereAuditEventFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditeventfactory.name", objid, "name","AuditEventFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditeventfactory.classname", objid, "className","AuditEventFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  auditSpecifications = Util.parseConfigIdListAttribute(objid, 'auditSpecifications',"AuditEventFactory");
  for auditSpecification in auditSpecifications:
    if auditSpecification is not None and len(auditSpecification) > 0:
      returndict = Util.createTypeFolder(respath, "AuditSpecificationRef", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, AuditSpecificationRef._export(auditSpecification, currespath, Util.getRequiredAttribute(auditSpecification, 'name', 'AuditSpecification')));

  auditServiceProvider = Util.getOptionalAttribute(objid, 'auditServiceProvider', 'AuditEventFactory');
  if auditServiceProvider is not None and len(auditServiceProvider) > 0:
    returndict = Util.createTypeFolder(respath, "AuditServiceProviderRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, AuditServiceProviderRef._export(auditServiceProvider, currespath, Util.getRequiredAttribute(auditServiceProvider, 'name', 'AuditServiceProvider')));

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"AuditEventFactory");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuditEventFactory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuditEventFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditEventFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.auditeventfactory.name", None));
  Util.addIfNotNone(properties, "className", roleProperties.optString("websphere.auditeventfactory.classname", None));
  print "Creating AuditEventFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuditEventFactory", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 1):
        continue;
      if currole == "WebSphereAuditSpecificationRef":
        AuditSpecificationRef.create(objid, curjsonobject, "auditSpecifications");
      elif currole == "WebSphereAuditServiceProviderRef":
        AuditServiceProviderRef.create(objid, curjsonobject, "auditServiceProvider");
  Util.popPathElement('AuditEventFactory');


def update(objid,jsonobject):
  Util.pushPathElement('AuditEventFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditEventFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditeventfactory.name", None), "name","AuditEventFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditeventfactory.classname", None), "className","AuditEventFactory");
  if len(atts) != 0:
    print "Modifying AuditEventFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuditEventFactory configuration up to date.";

  Property.removeProperties(objid, 'properties',"AuditEventFactory");

  Util.unsetAttribute(objid, "auditSpecifications", "AuditEventFactory");

  Util.unsetAttribute(objid, "auditServiceProvider", "AuditEventFactory");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 1):
        continue;
      if currole == "WebSphereAuditSpecificationRef":
        AuditSpecificationRef.create(objid, curjsonobject, "auditSpecifications");
      elif currole == "WebSphereAuditServiceProviderRef":
        AuditServiceProviderRef.create(objid, curjsonobject, "auditServiceProvider");
  Util.popPathElement('AuditEventFactory');
