from org.codehaus.jettison.json import JSONObject, JSONArray
from Service import Service
from Component import Component
from Property import Property
from ThreadPool import ThreadPool
from utilities import Util
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JobManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJobManager");
  exportedObject.put("roleName", "WebSphereJobManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanager.datasource", objid, "datasource","JobManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanager.name", objid, "name","JobManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanager.senderemail", objid, "senderEmail","JobManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanager.defaultjobexpiration", objid, "defaultJobExpiration","JobManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanager.url", objid, "URL","JobManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanager.jobnotificationmailsession", objid, "jobNotificationMailSession","JobManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jobmanager.databasemaxreturn", objid, "databaseMaxReturn","JobManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"JobManager");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "JobManager");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "JobManager");

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'JobManager');
  if threadPool is not None and len(threadPool) > 0:
    returndict = Util.createTypeFolder(respath, "ThreadPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ThreadPool._export(threadPool, currespath));

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"JobManager");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));      
    
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JobManager');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('JobManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "datasource", roleProperties.optString("websphere.jobmanager.datasource", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.jobmanager.name", None));
  Util.addIfNotNone(properties, "senderEmail", roleProperties.optString("websphere.jobmanager.senderemail", None));
  Util.addIfNotNone(properties, "defaultJobExpiration", roleProperties.optString("websphere.jobmanager.defaultjobexpiration", None));
  Util.addIfNotNone(properties, "URL", roleProperties.optString("websphere.jobmanager.url", None));
  Util.addIfNotNone(properties, "jobNotificationMailSession", roleProperties.optString("websphere.jobmanager.jobnotificationmailsession", None));
  Util.addIfNotNone(properties, "databaseMaxReturn", roleProperties.optString("websphere.jobmanager.databasemaxreturn", None));
  print "Creating JobManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JobManager", parentid, properties);

  Property.removeProperties(objid, 'properties',"JobManager");
  Component.removeComponents(objid, 'components', "JobManager");
  Service.removeServices(objid, 'services', "JobManager");

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'JobManager');
  if threadPool is not None and len(threadPool) > 0:
    Util.remove(threadPool);

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"JobManager");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);        
    
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereThreadPool":
            ThreadPool.create(objid, curjsonobject);
          elif currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);                        
  Util.popPathElement('JobManager');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('JobManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("JobManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanager.datasource", None), "datasource","JobManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanager.name", None), "name","JobManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanager.senderemail", None), "senderEmail","JobManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanager.defaultjobexpiration", None), "defaultJobExpiration","JobManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanager.url", None), "URL","JobManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanager.jobnotificationmailsession", None), "jobNotificationMailSession","JobManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jobmanager.databasemaxreturn", None), "databaseMaxReturn","JobManager");
  if len(atts) != 0:
    print "Modifying JobManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JobManager configuration up to date.";

  Property.removeProperties(objid, 'properties',"JobManager");
  Component.removeComponents(objid, 'components', "JobManager");
  Service.removeServices(objid, 'services', "JobManager");

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'JobManager');
  if threadPool is not None and len(threadPool) > 0:
    Util.remove(threadPool);

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"JobManager");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);       
    
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereThreadPool":
            ThreadPool.create(objid, curjsonobject);
          elif currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);            
  Util.popPathElement('JobManager');
