from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MatchRule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMatchRule");
  exportedObject.put("roleName", "WebSphereMatchRule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.matchrule.matchexpression", objid, "matchExpression","MatchRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.matchrule.priority", objid, "priority","MatchRule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.matchrule.matchaction", objid, "matchAction","MatchRule");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MatchRule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MatchRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("MatchRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "matchExpression", roleProperties.optString("websphere.matchrule.matchexpression", None));
  Util.addIfNotNone(properties, "priority", roleProperties.optString("websphere.matchrule.priority", None));
  Util.addIfNotNone(properties, "matchAction", roleProperties.optString("websphere.matchrule.matchaction", None));
  print "Creating MatchRule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MatchRule", parentid, properties);
  Util.popPathElement('MatchRule');

def update(objid,jsonobject):
  Util.pushPathElement('MatchRule')
  if not jsonobject.has("roleProperties"):
    raise Exception("MatchRule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.matchrule.matchexpression", None), "matchExpression","MatchRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.matchrule.priority", None), "priority","MatchRule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.matchrule.matchaction", None), "matchAction","MatchRule");
  if len(atts) != 0:
    print "Modifying MatchRule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MatchRule configuration up to date.";

  Util.popPathElement('MatchRule');
