from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RoleBasedAuthorization')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRoleBasedAuthorization");
  exportedObject.put("roleName", "WebSphereRoleBasedAuthorization");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rolebasedauthorization.name", objid, "name","RoleBasedAuthorization");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RoleBasedAuthorization');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RoleBasedAuthorization')
  if not jsonobject.has("roleProperties"):
    raise Exception("RoleBasedAuthorization resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.rolebasedauthorization.name", None));
  print "Creating RoleBasedAuthorization with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RoleBasedAuthorization", parentid, properties);
  Util.popPathElement('RoleBasedAuthorization');

def update(objid,jsonobject):
  Util.pushPathElement('RoleBasedAuthorization')
  if not jsonobject.has("roleProperties"):
    raise Exception("RoleBasedAuthorization resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rolebasedauthorization.name", None), "name","RoleBasedAuthorization");
  if len(atts) != 0:
    print "Modifying RoleBasedAuthorization with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RoleBasedAuthorization configuration up to date.";

  Util.popPathElement('RoleBasedAuthorization');
