from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('J2EEEAttribute')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJ2EEEAttribute");
  exportedObject.put("roleName", "WebSphereJ2EEEAttribute");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.derived", objid, "derived","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.name", objid, "name","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.transient", objid, "transient","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.upperbound", objid, "upperBound","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.unsettable", objid, "unsettable","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.unique", objid, "unique","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.volatile", objid, "volatile","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.ordered", objid, "ordered","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.id", objid, "iD","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.defaultvalueliteral", objid, "defaultValueLiteral","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.lowerbound", objid, "lowerBound","J2EEEAttribute");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeeattribute.changeable", objid, "changeable","J2EEEAttribute");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('J2EEEAttribute');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('J2EEEAttribute')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEEAttribute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "derived", roleProperties.optString("websphere.j2eeeattribute.derived", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.j2eeeattribute.name", None));
  Util.addIfNotNone(properties, "transient", roleProperties.optString("websphere.j2eeeattribute.transient", None));
  Util.addIfNotNone(properties, "upperBound", roleProperties.optString("websphere.j2eeeattribute.upperbound", None));
  Util.addIfNotNone(properties, "unsettable", roleProperties.optString("websphere.j2eeeattribute.unsettable", None));
  Util.addIfNotNone(properties, "unique", roleProperties.optString("websphere.j2eeeattribute.unique", None));
  Util.addIfNotNone(properties, "volatile", roleProperties.optString("websphere.j2eeeattribute.volatile", None));
  Util.addIfNotNone(properties, "ordered", roleProperties.optString("websphere.j2eeeattribute.ordered", None));
  Util.addIfNotNone(properties, "iD", roleProperties.optString("websphere.j2eeeattribute.id", None));
  Util.addIfNotNone(properties, "defaultValueLiteral", roleProperties.optString("websphere.j2eeeattribute.defaultvalueliteral", None));
  Util.addIfNotNone(properties, "lowerBound", roleProperties.optString("websphere.j2eeeattribute.lowerbound", None));
  Util.addIfNotNone(properties, "changeable", roleProperties.optString("websphere.j2eeeattribute.changeable", None));
  print "Creating J2EEEAttribute with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("J2EEEAttribute", parentid, properties);
  Util.popPathElement('J2EEEAttribute');

def update(objid,jsonobject):
  Util.pushPathElement('J2EEEAttribute')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEEAttribute resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.derived", None), "derived","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.name", None), "name","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.transient", None), "transient","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.upperbound", None), "upperBound","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.unsettable", None), "unsettable","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.unique", None), "unique","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.volatile", None), "volatile","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.ordered", None), "ordered","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.id", None), "iD","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.defaultvalueliteral", None), "defaultValueLiteral","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.lowerbound", None), "lowerBound","J2EEEAttribute");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeeattribute.changeable", None), "changeable","J2EEEAttribute");
  if len(atts) != 0:
    print "Modifying J2EEEAttribute with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "J2EEEAttribute configuration up to date.";

  Util.popPathElement('J2EEEAttribute');
