from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PerformanceGoal')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePerformanceGoal");
  exportedObject.put("roleName", "WebSpherePerformanceGoal");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.importance", objid, "importance","PerformanceGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.goalvalue", objid, "goalValue","PerformanceGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.timeperiodvalueunits", objid, "timePeriodValueUnits","PerformanceGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.violationenabled", objid, "violationEnabled","PerformanceGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.goaldeltavalueunits", objid, "goalDeltaValueUnits","PerformanceGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.goalvalueunits", objid, "goalValueUnits","PerformanceGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.goaldeltavalue", objid, "goalDeltaValue","PerformanceGoal");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.performancegoal.timeperiodvalue", objid, "timePeriodValue","PerformanceGoal");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PerformanceGoal');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PerformanceGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("PerformanceGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "importance", roleProperties.optString("websphere.performancegoal.importance", None));
  Util.addIfNotNone(properties, "goalValue", roleProperties.optString("websphere.performancegoal.goalvalue", None));
  Util.addIfNotNone(properties, "timePeriodValueUnits", roleProperties.optString("websphere.performancegoal.timeperiodvalueunits", None));
  Util.addIfNotNone(properties, "violationEnabled", roleProperties.optString("websphere.performancegoal.violationenabled", None));
  Util.addIfNotNone(properties, "goalDeltaValueUnits", roleProperties.optString("websphere.performancegoal.goaldeltavalueunits", None));
  Util.addIfNotNone(properties, "goalValueUnits", roleProperties.optString("websphere.performancegoal.goalvalueunits", None));
  Util.addIfNotNone(properties, "goalDeltaValue", roleProperties.optString("websphere.performancegoal.goaldeltavalue", None));
  Util.addIfNotNone(properties, "timePeriodValue", roleProperties.optString("websphere.performancegoal.timeperiodvalue", None));
  print "Creating PerformanceGoal with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PerformanceGoal", parentid, properties);
  Util.popPathElement('PerformanceGoal');

def update(objid,jsonobject):
  Util.pushPathElement('PerformanceGoal')
  if not jsonobject.has("roleProperties"):
    raise Exception("PerformanceGoal resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.importance", None), "importance","PerformanceGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.goalvalue", None), "goalValue","PerformanceGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.timeperiodvalueunits", None), "timePeriodValueUnits","PerformanceGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.violationenabled", None), "violationEnabled","PerformanceGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.goaldeltavalueunits", None), "goalDeltaValueUnits","PerformanceGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.goalvalueunits", None), "goalValueUnits","PerformanceGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.goaldeltavalue", None), "goalDeltaValue","PerformanceGoal");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.performancegoal.timeperiodvalue", None), "timePeriodValue","PerformanceGoal");
  if len(atts) != 0:
    print "Modifying PerformanceGoal with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PerformanceGoal configuration up to date.";

  Util.popPathElement('PerformanceGoal');
