from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from HealthTime import HealthTime
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RestartTime')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRestartTime");
  exportedObject.put("roleName", "WebSphereRestartTime");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.restarttime.sunday", objid, "sunday","RestartTime");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.restarttime.wednesday", objid, "wednesday","RestartTime");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.restarttime.thursday", objid, "thursday","RestartTime");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.restarttime.saturday", objid, "saturday","RestartTime");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.restarttime.friday", objid, "friday","RestartTime");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.restarttime.tuesday", objid, "tuesday","RestartTime");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.restarttime.monday", objid, "monday","RestartTime");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  endTime = Util.getOptionalAttribute(objid, 'endTime', 'RestartTime');
  if endTime is not None and len(endTime) > 0:
    returndict = Util.createTypeFolder(respath, "HealthTime", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, HealthTime._export(endTime, currespath, 'endTime'));

  startTime = Util.getOptionalAttribute(objid, 'startTime', 'RestartTime');
  if startTime is not None and len(startTime) > 0:
    returndict = Util.createTypeFolder(respath, "HealthTime", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, HealthTime._export(startTime, currespath, 'startTime'));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RestartTime');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RestartTime')
  if not jsonobject.has("roleProperties"):
    raise Exception("RestartTime resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "sunday", roleProperties.optString("websphere.restarttime.sunday", None));
  Util.addIfNotNone(properties, "wednesday", roleProperties.optString("websphere.restarttime.wednesday", None));
  Util.addIfNotNone(properties, "thursday", roleProperties.optString("websphere.restarttime.thursday", None));
  Util.addIfNotNone(properties, "saturday", roleProperties.optString("websphere.restarttime.saturday", None));
  Util.addIfNotNone(properties, "friday", roleProperties.optString("websphere.restarttime.friday", None));
  Util.addIfNotNone(properties, "tuesday", roleProperties.optString("websphere.restarttime.tuesday", None));
  Util.addIfNotNone(properties, "monday", roleProperties.optString("websphere.restarttime.monday", None));
  print "Creating RestartTime with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RestartTime", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereHealthTime":
        name = curjsonobject.getString('name');
        if name == "endTime":
          HealthTime.create(objid, curjsonobject, "endTime");
        elif name == "startTime":
          HealthTime.create(objid, curjsonobject, "startTime");
        else:
          print ("Warning: " + name + " is an invalid HealthTime attribute name for the RestartTime object.  " +
                 "Expected endTime or startTime.");
  Util.popPathElement('RestartTime');

def update(objid,jsonobject):
  Util.pushPathElement('RestartTime')
  if not jsonobject.has("roleProperties"):
    raise Exception("RestartTime resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.restarttime.sunday", None), "sunday","RestartTime");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.restarttime.wednesday", None), "wednesday","RestartTime");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.restarttime.thursday", None), "thursday","RestartTime");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.restarttime.saturday", None), "saturday","RestartTime");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.restarttime.friday", None), "friday","RestartTime");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.restarttime.tuesday", None), "tuesday","RestartTime");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.restarttime.monday", None), "monday","RestartTime");
  if len(atts) != 0:
    print "Modifying RestartTime with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RestartTime configuration up to date.";

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereHealthTime":
        name = curjsonobject.getString('name');
        if name == "endTime":
          endTime = Util.getOptionalAttribute(objid, 'endTime', 'RestartTime');
          if endTime is not None and len(endTime) > 0:
            Util.remove(endTime);
          HealthTime.create(objid, curjsonobject, "endTime");
        elif name == "startTime":
          startTime = Util.getOptionalAttribute(objid, 'startTime', 'RestartTime');
          if startTime is not None and len(startTime) > 0:
            Util.remove(startTime);
          HealthTime.create(objid, curjsonobject, "startTime");
        else:
          print ("Warning: " + name + " is an invalid HealthTime attribute name for the RestartTime object.  " +
                 "Expected endTime or startTime.");

  Util.popPathElement('RestartTime');
