from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TransactionClass')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransactionClass");
  exportedObject.put("roleName", "WebSphereTransactionClass");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionclass.name", objid, "name","TransactionClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transactionclass.description", objid, "description","TransactionClass");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TransactionClass');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TransactionClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransactionClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.transactionclass.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.transactionclass.description", None));
  print "Creating TransactionClass with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TransactionClass", parentid, properties);
  Util.popPathElement('TransactionClass');

def update(objid,jsonobject):
  Util.pushPathElement('TransactionClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransactionClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionclass.name", None), "name","TransactionClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transactionclass.description", None), "description","TransactionClass");
  if len(atts) != 0:
    print "Modifying TransactionClass with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TransactionClass configuration up to date.";

  Util.popPathElement('TransactionClass');
