from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationResources')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationResources");
  exportedObject.put("roleName", "WebSphereApplicationResources");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationresources.applicationgroup", objid, "applicationGroup","ApplicationResources");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationResources');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ApplicationResources')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationResources resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "applicationGroup", roleProperties.optString("websphere.applicationresources.applicationgroup", None));
  print "Creating ApplicationResources with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationResources", parentid, properties);
  Util.popPathElement('ApplicationResources');

def update(objid,jsonobject):
  Util.pushPathElement('ApplicationResources')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationResources resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationresources.applicationgroup", None), "applicationGroup","ApplicationResources");
  if len(atts) != 0:
    print "Modifying ApplicationResources with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationResources configuration up to date.";

  Util.popPathElement('ApplicationResources');
