from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ApplicationServerTimeMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereApplicationServerTimeMapping");
  exportedObject.put("roleName", "WebSphereApplicationServerTimeMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationservertimemapping.endtime", objid, "endTime","ApplicationServerTimeMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationservertimemapping.starttime", objid, "startTime","ApplicationServerTimeMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.applicationservertimemapping.action", objid, "action","ApplicationServerTimeMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ApplicationServerTimeMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ApplicationServerTimeMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerTimeMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "endTime", roleProperties.optString("websphere.applicationservertimemapping.endtime", None));
  Util.addIfNotNone(properties, "startTime", roleProperties.optString("websphere.applicationservertimemapping.starttime", None));
  Util.addIfNotNone(properties, "action", roleProperties.optString("websphere.applicationservertimemapping.action", None));
  print "Creating ApplicationServerTimeMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ApplicationServerTimeMapping", parentid, properties);
  Util.popPathElement('ApplicationServerTimeMapping');

def update(objid,jsonobject):
  Util.pushPathElement('ApplicationServerTimeMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ApplicationServerTimeMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationservertimemapping.endtime", None), "endTime","ApplicationServerTimeMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationservertimemapping.starttime", None), "startTime","ApplicationServerTimeMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.applicationservertimemapping.action", None), "action","ApplicationServerTimeMapping");
  if len(atts) != 0:
    print "Modifying ApplicationServerTimeMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ApplicationServerTimeMapping configuration up to date.";

  Util.popPathElement('ApplicationServerTimeMapping');
