from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;


def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('CoreGroupServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereCoreGroupServer");
  exportedObject.put("roleName", "WebSphereCoreGroupServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.coregroupserver.preferredipaddress", objid, "preferredIPAddress","CoreGroupServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.coregroupserver.servername", objid, "serverName","CoreGroupServer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.coregroupserver.nodename", objid, "nodeName","CoreGroupServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  
  extraObjects = Property.exportProperties(objid,respath,extraObjects,typeFolders,'customProperties',"CoreGroupServer");
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('CoreGroupServer');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('CoreGroupServer')
  parentAtt = "coreGroupServers";
  
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "preferredIPAddress", roleProperties.optString("websphere.coregroupserver.preferredipaddress", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.coregroupserver.servername", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.coregroupserver.nodename", None));
  print "Creating CoreGroupServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("CoreGroupServer", parentid, properties, parentAtt);

  props = Util.parseConfigIdListAttribute(objid, 'customProperties',"CoreGroupServer");
  for prop in props:
    Util.remove(prop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CoreGroupServer');

def update(objid,jsonobject):
  Util.pushPathElement('CoreGroupServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("CoreGroupServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.coregroupserver.preferredipaddress", None), "preferredIPAddress","CoreGroupServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.coregroupserver.servername", None), "serverName","CoreGroupServer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.coregroupserver.nodename", None), "nodeName","CoreGroupServer");
  if len(atts) != 0:
    print "Modifying CoreGroupServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "CoreGroupServer configuration up to date.";

  Property.removeProperties(objid, 'customProperties',"CoreGroupServer");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('CoreGroupServer');
