from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EJBAsync')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEJBAsync");
  exportedObject.put("roleName", "WebSphereEJBAsync");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbasync.workreqqfullaction", objid, "workReqQFullAction","EJBAsync");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbasync.usecustomdefinedwm", objid, "useCustomDefinedWM","EJBAsync");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbasync.maxthreads", objid, "maxThreads","EJBAsync");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbasync.workreqqsize", objid, "workReqQSize","EJBAsync");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbasync.customworkmanagerjndiname", objid, "customWorkManagerJNDIName","EJBAsync");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ejbasync.futuretimeout", objid, "futureTimeout","EJBAsync");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EJBAsync');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EJBAsync')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBAsync resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "workReqQFullAction", roleProperties.optString("websphere.ejbasync.workreqqfullaction", None));
  Util.addIfNotNone(properties, "useCustomDefinedWM", roleProperties.optString("websphere.ejbasync.usecustomdefinedwm", None));
  Util.addIfNotNone(properties, "maxThreads", roleProperties.optString("websphere.ejbasync.maxthreads", None));
  Util.addIfNotNone(properties, "workReqQSize", roleProperties.optString("websphere.ejbasync.workreqqsize", None));
  Util.addIfNotNone(properties, "customWorkManagerJNDIName", roleProperties.optString("websphere.ejbasync.customworkmanagerjndiname", None));
  Util.addIfNotNone(properties, "futureTimeout", roleProperties.optString("websphere.ejbasync.futuretimeout", None));
  print "Creating EJBAsync with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EJBAsync", parentid, properties);
  Util.popPathElement('EJBAsync');

def update(objid,jsonobject):
  Util.pushPathElement('EJBAsync')
  if not jsonobject.has("roleProperties"):
    raise Exception("EJBAsync resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbasync.workreqqfullaction", None), "workReqQFullAction","EJBAsync");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbasync.usecustomdefinedwm", None), "useCustomDefinedWM","EJBAsync");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbasync.maxthreads", None), "maxThreads","EJBAsync");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbasync.workreqqsize", None), "workReqQSize","EJBAsync");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbasync.customworkmanagerjndiname", None), "customWorkManagerJNDIName","EJBAsync");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ejbasync.futuretimeout", None), "futureTimeout","EJBAsync");
  if len(atts) != 0:
    print "Modifying EJBAsync with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EJBAsync configuration up to date.";

  Util.popPathElement('EJBAsync');
