from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ExternalCacheGroupMember import ExternalCacheGroupMember
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ExternalCacheGroup')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExternalCacheGroup");
  exportedObject.put("roleName", "WebSphereExternalCacheGroup");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externalcachegroup.name", objid, "name","ExternalCacheGroup");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.externalcachegroup.type", objid, "type","ExternalCacheGroup");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  members = Util.parseConfigIdListAttribute(objid, 'members',"ExternalCacheGroup");
  for member in members:
    if len(member) > 0:
      returndict = Util.createTypeFolder(respath, "ExternalCacheGroupMember", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ExternalCacheGroupMember._export(member, currespath, "ExternalCacheGroupMember%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExternalCacheGroup');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ExternalCacheGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalCacheGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.externalcachegroup.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.externalcachegroup.type", None));
  print "Creating ExternalCacheGroup with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExternalCacheGroup", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereExternalCacheGroupMember":
        ExternalCacheGroupMember.create(objid, curjsonobject);
  Util.popPathElement('ExternalCacheGroup');

def update(objid,jsonobject):
  Util.pushPathElement('ExternalCacheGroup')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExternalCacheGroup resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externalcachegroup.name", None), "name","ExternalCacheGroup");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.externalcachegroup.type", None), "type","ExternalCacheGroup");
  if len(atts) != 0:
    print "Modifying ExternalCacheGroup with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExternalCacheGroup configuration up to date.";

  members = Util.parseConfigIdListAttribute(objid, 'members',"ExternalCacheGroup");
  for member in members:
    if len(member) > 0:
      Util.remove(member);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereExternalCacheGroupMember":
        ExternalCacheGroupMember.create(objid, curjsonobject);
  Util.popPathElement('ExternalCacheGroup');
