from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GCPercentageCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGCPercentageCondition");
  exportedObject.put("roleName", "WebSphereGCPercentageCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gcpercentagecondition.samplingperiod", objid, "samplingPeriod","GCPercentageCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gcpercentagecondition.name", objid, "name","GCPercentageCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gcpercentagecondition.samplingunits", objid, "samplingUnits","GCPercentageCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gcpercentagecondition.garbagecollectionpercent", objid, "garbageCollectionPercent","GCPercentageCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.gcpercentagecondition.conditionexpr", objid, "conditionExpr","GCPercentageCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GCPercentageCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GCPercentageCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("GCPercentageCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "samplingPeriod", roleProperties.optString("websphere.gcpercentagecondition.samplingperiod", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.gcpercentagecondition.name", None));
  Util.addIfNotNone(properties, "samplingUnits", roleProperties.optString("websphere.gcpercentagecondition.samplingunits", None));
  Util.addIfNotNone(properties, "garbageCollectionPercent", roleProperties.optString("websphere.gcpercentagecondition.garbagecollectionpercent", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.gcpercentagecondition.conditionexpr", None));
  print "Creating GCPercentageCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GCPercentageCondition", parentid, properties);
  Util.popPathElement('GCPercentageCondition');

def update(objid,jsonobject):
  Util.pushPathElement('GCPercentageCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("GCPercentageCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gcpercentagecondition.samplingperiod", None), "samplingPeriod","GCPercentageCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gcpercentagecondition.name", None), "name","GCPercentageCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gcpercentagecondition.samplingunits", None), "samplingUnits","GCPercentageCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gcpercentagecondition.garbagecollectionpercent", None), "garbageCollectionPercent","GCPercentageCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.gcpercentagecondition.conditionexpr", None), "conditionExpr","GCPercentageCondition");
  if len(atts) != 0:
    print "Modifying GCPercentageCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GCPercentageCondition configuration up to date.";

  Util.popPathElement('GCPercentageCondition');
