from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = "websphere.genericinboundchannel.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'GenericInboundChannel');

  containmentpath = "%(parentconpath)sGenericInboundChannel:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('GenericInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'GenericInboundChannel');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericInboundChannel");
  exportedObject.put("roleName", "WebSphereGenericInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericinboundchannel.name", objid, "name","GenericInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericinboundchannel.discriminationweight", objid, "discriminationWeight","GenericInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericinboundchannel.typeid", objid, "typeID","GenericInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericinboundchannel.configuri", objid, "configURI","GenericInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericinboundchannel.jarfile", objid, "jarFile","GenericInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"GenericInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericInboundChannel');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.genericinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.genericinboundchannel.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create GenericInboundChannel on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.genericinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.genericinboundchannel.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.genericinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.genericinboundchannel.discriminationweight", None));
  Util.addIfNotNone(properties, "typeID", roleProperties.optString("websphere.genericinboundchannel.typeid", None));
  Util.addIfNotNone(properties, "configURI", roleProperties.optString("websphere.genericinboundchannel.configuri", None));
  Util.addIfNotNone(properties, "jarFile", roleProperties.optString("websphere.genericinboundchannel.jarfile", None));
  print "Creating GenericInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericInboundChannel", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('GenericInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('GenericInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.genericinboundchannel.name"):
    raise Exception("Resource role properties does not contain websphere.genericinboundchannel.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericinboundchannel.name", None), "name","GenericInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericinboundchannel.discriminationweight", None), "discriminationWeight","GenericInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericinboundchannel.typeid", None), "typeID","GenericInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericinboundchannel.configuri", None), "configURI","GenericInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericinboundchannel.jarfile", None), "jarFile","GenericInboundChannel");
  if len(atts) != 0:
    print "Modifying GenericInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"GenericInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('GenericInboundChannel');
