from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = "", ordernum = None):
  Util.pushPathElement('JAASLoginModule')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJAASLoginModule");
  exportedObject.put("roleName", "WebSphereJAASLoginModule");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaasloginmodule.callbackhandlerclassname", objid, "callbackHandlerClassName","JAASLoginModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaasloginmodule.moduleclassname", objid, "moduleClassName","JAASLoginModule");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaasloginmodule.authenticationstrategy", objid, "authenticationStrategy","JAASLoginModule");
  roleProperties.put("websphere.jaasloginmodule.ordernum", ordernum);
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'options',"JAASLoginModule");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JAASLoginModule');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JAASLoginModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAASLoginModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "callbackHandlerClassName", roleProperties.optString("websphere.jaasloginmodule.callbackhandlerclassname", None));
  Util.addIfNotNone(properties, "moduleClassName", roleProperties.optString("websphere.jaasloginmodule.moduleclassname", None));
  Util.addIfNotNone(properties, "authenticationStrategy", roleProperties.optString("websphere.jaasloginmodule.authenticationstrategy", None));
  print "Creating JAASLoginModule with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JAASLoginModule", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JAASLoginModule');

def update(objid,jsonobject):
  Util.pushPathElement('JAASLoginModule')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAASLoginModule resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaasloginmodule.callbackhandlerclassname", None), "callbackHandlerClassName","JAASLoginModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaasloginmodule.moduleclassname", None), "moduleClassName","JAASLoginModule");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaasloginmodule.authenticationstrategy", None), "authenticationStrategy","JAASLoginModule");
  if len(atts) != 0:
    print "Modifying JAASLoginModule with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JAASLoginModule configuration up to date.";

  Property.removeProperties(objid, 'options',"JAASLoginModule");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JAASLoginModule');

def getOrderFromJSON(jsonobject):
  roleProperties = jsonobject.getJSONObject("roleProperties");
  return roleProperties.optString("websphere.jaasloginmodule.ordernum", None)
