from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from ManagementScopeRef import ManagementScopeRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('KeyManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereKeyManager");
  exportedObject.put("roleName", "WebSphereKeyManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keymanager.algorithm", objid, "algorithm","KeyManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keymanager.name", objid, "name","KeyManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keymanager.keymanagerclass", objid, "keyManagerClass","KeyManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keymanager.provider", objid, "provider","KeyManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'additionalKeyManagerAttrs',"KeyManager","AdditionalKeyManagerAttrs");

  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'KeyManager');
  if managementScope is not None and len(managementScope) > 0:
    returndict = Util.createTypeFolder(respath, "ManagementScopeRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ManagementScopeRef._export(managementScope, currespath, "ManagementScope"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('KeyManager');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('KeyManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("KeyManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "algorithm", roleProperties.optString("websphere.keymanager.algorithm", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.keymanager.name", None));
  Util.addIfNotNone(properties, "keyManagerClass", roleProperties.optString("websphere.keymanager.keymanagerclass", None));
  Util.addIfNotNone(properties, "provider", roleProperties.optString("websphere.keymanager.provider", None));
  print "Creating KeyManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("KeyManager", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      attName = None;
      currpath = curjsonobject.getString('path');
      lastSlashIndex = currpath.rindex('/');
      nextToLastSlashIndex = currpath.rindex('/', 0, lastSlashIndex - 1);
      foldername = currpath[nextToLastSlashIndex+1:lastSlashIndex];
      if (foldername.find(Util.getTypeFoldername('AdditionalKeyManagerAttrs')) > -1):
        attName = 'additionalKeyManagerAttrs';
      propertObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole, attName);
      if (propertyObject == 0):
        if currole == "WebSphereManagementScopeRef":
          ManagementScopeRef.create(objid, curjsonobject, "managementScope");
  Util.popPathElement('KeyManager');

def update(objid,jsonobject):
  Util.pushPathElement('KeyManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("KeyManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keymanager.algorithm", None), "algorithm","KeyManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keymanager.name", None), "name","KeyManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keymanager.keymanagerclass", None), "keyManagerClass","KeyManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.keymanager.provider", None), "provider","KeyManager");
  if len(atts) != 0:
    print "Modifying KeyManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "KeyManager configuration up to date.";

  Property.removeProperties(objid, 'additionalKeyManagerAttrs',"KeyManager");

  Util.unsetAttribute(objid, "managementScope", "KeyManager");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      attName = None;
      currpath = curjsonobject.getString('path');
      lastSlashIndex = currpath.rindex('/');
      nextToLastSlashIndex = currpath.rindex('/', 0, lastSlashIndex - 1);
      foldername = currpath[nextToLastSlashIndex+1:lastSlashIndex];
      if (foldername.find(Util.getTypeFoldername('AdditionalKeyManagerAttrs')) > -1):
        attName = 'additionalKeyManagerAttrs';
      propertObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole, attName);
      if (propertyObject == 0):
        if currole == "WebSphereManagementScopeRef":
          ManagementScopeRef.create(objid, curjsonobject, "managementScope");
  Util.popPathElement('KeyManager');
