from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LDAPSearchFilter')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLDAPSearchFilter");
  exportedObject.put("roleName", "WebSphereLDAPSearchFilter");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.krbuserfilter", objid, "krbUserFilter","LDAPSearchFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.groupmemberidmap", objid, "groupMemberIdMap","LDAPSearchFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.certificatefilter", objid, "certificateFilter","LDAPSearchFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.useridmap", objid, "userIdMap","LDAPSearchFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.userfilter", objid, "userFilter","LDAPSearchFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.groupidmap", objid, "groupIdMap","LDAPSearchFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.groupfilter", objid, "groupFilter","LDAPSearchFilter");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.ldapsearchfilter.certificatemapmode", objid, "certificateMapMode","LDAPSearchFilter");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LDAPSearchFilter');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LDAPSearchFilter')
  if not jsonobject.has("roleProperties"):
    raise Exception("LDAPSearchFilter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "krbUserFilter", roleProperties.optString("websphere.ldapsearchfilter.krbuserfilter", None));
  Util.addIfNotNone(properties, "groupMemberIdMap", roleProperties.optString("websphere.ldapsearchfilter.groupmemberidmap", None));
  Util.addIfNotNone(properties, "certificateFilter", roleProperties.optString("websphere.ldapsearchfilter.certificatefilter", None));
  Util.addIfNotNone(properties, "userIdMap", roleProperties.optString("websphere.ldapsearchfilter.useridmap", None));
  Util.addIfNotNone(properties, "userFilter", roleProperties.optString("websphere.ldapsearchfilter.userfilter", None));
  Util.addIfNotNone(properties, "groupIdMap", roleProperties.optString("websphere.ldapsearchfilter.groupidmap", None));
  Util.addIfNotNone(properties, "groupFilter", roleProperties.optString("websphere.ldapsearchfilter.groupfilter", None));
  Util.addIfNotNone(properties, "certificateMapMode", roleProperties.optString("websphere.ldapsearchfilter.certificatemapmode", None));
  print "Creating LDAPSearchFilter with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LDAPSearchFilter", parentid, properties);
  Util.popPathElement('LDAPSearchFilter');

def update(objid,jsonobject):
  Util.pushPathElement('LDAPSearchFilter')
  if not jsonobject.has("roleProperties"):
    raise Exception("LDAPSearchFilter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.krbuserfilter", None), "krbUserFilter","LDAPSearchFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.groupmemberidmap", None), "groupMemberIdMap","LDAPSearchFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.certificatefilter", None), "certificateFilter","LDAPSearchFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.useridmap", None), "userIdMap","LDAPSearchFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.userfilter", None), "userFilter","LDAPSearchFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.groupidmap", None), "groupIdMap","LDAPSearchFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.groupfilter", None), "groupFilter","LDAPSearchFilter");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.ldapsearchfilter.certificatemapmode", None), "certificateMapMode","LDAPSearchFilter");
  if len(atts) != 0:
    print "Modifying LDAPSearchFilter with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LDAPSearchFilter configuration up to date.";

  Util.popPathElement('LDAPSearchFilter');
