from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageLayer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageLayer");
  exportedObject.put("roleName", "WebSphereMessageLayer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelayer.isstateful", objid, "isStateful","MessageLayer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelayer.supportedauthmechlist", objid, "supportedAuthMechList","MessageLayer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelayer.useclaim", objid, "useClaim","MessageLayer");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelayer.authenticationlayerretrycount", objid, "authenticationLayerRetryCount","MessageLayer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageLayer');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MessageLayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageLayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "isStateful", roleProperties.optString("websphere.messagelayer.isstateful", None));
  Util.addIfNotNone(properties, "supportedAuthMechList", roleProperties.optString("websphere.messagelayer.supportedauthmechlist", None));
  Util.addIfNotNone(properties, "useClaim", roleProperties.optString("websphere.messagelayer.useclaim", None));
  Util.addIfNotNone(properties, "authenticationLayerRetryCount", roleProperties.optString("websphere.messagelayer.authenticationlayerretrycount", None));
  print "Creating MessageLayer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageLayer", parentid, properties);
  Util.popPathElement('MessageLayer');

def update(objid,jsonobject):
  Util.pushPathElement('MessageLayer')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageLayer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelayer.isstateful", None), "isStateful","MessageLayer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelayer.supportedauthmechlist", None), "supportedAuthMechList","MessageLayer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelayer.useclaim", None), "useClaim","MessageLayer");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelayer.authenticationlayerretrycount", None), "authenticationLayerRetryCount","MessageLayer");
  if len(atts) != 0:
    print "Modifying MessageLayer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageLayer configuration up to date.";

  Util.popPathElement('MessageLayer');
