from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBDatastore')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBDatastore");
  exportedObject.put("roleName", "WebSphereSIBDatastore");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.permanenttables", objid, "permanentTables","SIBDatastore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.createtables", objid, "createTables","SIBDatastore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.authalias", objid, "authAlias","SIBDatastore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.uuid", objid, "uuid","SIBDatastore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.restrictlongdblock", objid, "restrictLongDBLock","SIBDatastore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.datasourcename", objid, "dataSourceName","SIBDatastore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.temporarytables", objid, "temporaryTables","SIBDatastore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdatastore.schemaname", objid, "schemaName","SIBDatastore");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBDatastore');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBDatastore')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDatastore resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "permanentTables", roleProperties.optString("websphere.sibdatastore.permanenttables", None));
  Util.addIfNotNone(properties, "createTables", roleProperties.optString("websphere.sibdatastore.createtables", None));
  Util.addIfNotNone(properties, "authAlias", roleProperties.optString("websphere.sibdatastore.authalias", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibdatastore.uuid", None));
  Util.addIfNotNone(properties, "restrictLongDBLock", roleProperties.optString("websphere.sibdatastore.restrictlongdblock", "false"));
  Util.addIfNotNone(properties, "dataSourceName", roleProperties.optString("websphere.sibdatastore.datasourcename", None));
  Util.addIfNotNone(properties, "temporaryTables", roleProperties.optString("websphere.sibdatastore.temporarytables", None));
  Util.addIfNotNone(properties, "schemaName", roleProperties.optString("websphere.sibdatastore.schemaname", None));
  print "Creating SIBDatastore with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBDatastore", parentid, properties);
  Util.popPathElement('SIBDatastore');

def update(objid,jsonobject):
  Util.pushPathElement('SIBDatastore')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDatastore resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.permanenttables", None), "permanentTables","SIBDatastore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.createtables", None), "createTables","SIBDatastore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.authalias", None), "authAlias","SIBDatastore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.uuid", None), "uuid","SIBDatastore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.restrictlongdblock", "false"), "restrictLongDBLock","SIBDatastore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.datasourcename", None), "dataSourceName","SIBDatastore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.temporarytables", None), "temporaryTables","SIBDatastore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdatastore.schemaname", None), "schemaName","SIBDatastore");
  if len(atts) != 0:
    print "Modifying SIBDatastore with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBDatastore configuration up to date.";

  Util.popPathElement('SIBDatastore');
