from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBContextInfo import SIBContextInfo

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBDestinationDefault')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBDestinationDefault");
  exportedObject.put("roleName", "WebSphereSIBDestinationDefault");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationdefault.defaultpriority", objid, "defaultPriority","SIBDestinationDefault");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationdefault.maxreliability", objid, "maxReliability","SIBDestinationDefault");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationdefault.reliability", objid, "reliability","SIBDestinationDefault");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationdefault.overrideofqosbyproducerallowed", objid, "overrideOfQOSByProducerAllowed","SIBDestinationDefault");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibdestinationdefault.sendallowed", objid, "sendAllowed","SIBDestinationDefault");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  contextInfos = Util.parseConfigIdListAttribute(objid, 'contextInfo',"SIBDestinationDefault");
  for contextInfo in contextInfos:
    if len(contextInfo) > 0:
      returndict = Util.createTypeFolder(respath, "SIBContextInfo", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      contextInfoName = Util.getRequiredAttribute(contextInfo, 'name',"SIBContextInfo");
      Util.addAllFromExport(extraObjects, SIBContextInfo._export(contextInfo, currespath, contextInfoName));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBDestinationDefault');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBDestinationDefault')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationDefault resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "defaultPriority", roleProperties.optString("websphere.sibdestinationdefault.defaultpriority", None));
  Util.addIfNotNone(properties, "maxReliability", roleProperties.optString("websphere.sibdestinationdefault.maxreliability", None));
  Util.addIfNotNone(properties, "reliability", roleProperties.optString("websphere.sibdestinationdefault.reliability", None));
  Util.addIfNotNone(properties, "overrideOfQOSByProducerAllowed", roleProperties.optString("websphere.sibdestinationdefault.overrideofqosbyproducerallowed", None));
  Util.addIfNotNone(properties, "sendAllowed", roleProperties.optString("websphere.sibdestinationdefault.sendallowed", None));
  print "Creating SIBDestinationDefault with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBDestinationDefault", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBContextInfo":
        SIBContextInfo.create(objid, curjsonobject);
  Util.popPathElement('SIBDestinationDefault');

def update(objid,jsonobject):
  Util.pushPathElement('SIBDestinationDefault')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBDestinationDefault resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationdefault.defaultpriority", None), "defaultPriority","SIBDestinationDefault");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationdefault.maxreliability", None), "maxReliability","SIBDestinationDefault");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationdefault.reliability", None), "reliability","SIBDestinationDefault");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationdefault.overrideofqosbyproducerallowed", None), "overrideOfQOSByProducerAllowed","SIBDestinationDefault");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibdestinationdefault.sendallowed", None), "sendAllowed","SIBDestinationDefault");
  if len(atts) != 0:
    print "Modifying SIBDestinationDefault with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBDestinationDefault configuration up to date.";

  contextInfos = Util.parseConfigIdListAttribute(objid, 'contextInfo',"SIBDestinationDefault");
  for contextInfo in contextInfos:
    if len(contextInfo) > 0:
      Util.remove(contextInfo);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSIBContextInfo":
        SIBContextInfo.create(objid, curjsonobject);

  Util.popPathElement('SIBDestinationDefault');
