from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property
from ManagementScopeRef import ManagementScopeRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TrustManager')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTrustManager");
  exportedObject.put("roleName", "WebSphereTrustManager");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.algorithm", objid, "algorithm","TrustManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.name", objid, "name","TrustManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.trustmanagerclass", objid, "trustManagerClass","TrustManager");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.trustmanager.provider", objid, "provider","TrustManager");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'additionalTrustManagerAttrs',"TrustManager","AdditionalTrustManagerAttrs");

  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'TrustManager');
  if managementScope is not None and len(managementScope) > 0:
    returndict = Util.createTypeFolder(respath, "ManagementScopeRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ManagementScopeRef._export(managementScope, currespath, "ManagementScope"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TrustManager');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TrustManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "algorithm", roleProperties.optString("websphere.trustmanager.algorithm", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.trustmanager.name", None));
  Util.addIfNotNone(properties, "trustManagerClass", roleProperties.optString("websphere.trustmanager.trustmanagerclass", None));
  Util.addIfNotNone(properties, "provider", roleProperties.optString("websphere.trustmanager.provider", None));
  print "Creating TrustManager with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TrustManager", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      attName = None;
      currpath = curjsonobject.getString('path');
      lastSlashIndex = currpath.rindex('/');
      nextToLastSlashIndex = currpath.rindex('/', 0, lastSlashIndex - 1);
      foldername = currpath[nextToLastSlashIndex+1:lastSlashIndex];
      if (foldername.find(Util.getTypeFoldername('AdditionalTrustManagerAttrs')) > -1):
        attName = 'additionalTrustManagerAttrs';
      propertObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole, attName);
      if (propertyObject == 0):
        if currole == "WebSphereManagementScopeRef":
          ManagementScopeRef.create(objid, curjsonobject, "managementScope");
  Util.popPathElement('TrustManager');

def update(objid,jsonobject):
  Util.pushPathElement('TrustManager')
  if not jsonobject.has("roleProperties"):
    raise Exception("TrustManager resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.algorithm", None), "algorithm","TrustManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.name", None), "name","TrustManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.trustmanagerclass", None), "trustManagerClass","TrustManager");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.trustmanager.provider", None), "provider","TrustManager");
  if len(atts) != 0:
    print "Modifying TrustManager with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TrustManager configuration up to date.";

  Property.removeProperties(objid, 'additionalTrustManagerAttrs',"TrustManager");

  Util.unsetAttribute(objid, "managementScope", "TrustManager");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      attName = None;
      currpath = curjsonobject.getString('path');
      lastSlashIndex = currpath.rindex('/');
      nextToLastSlashIndex = currpath.rindex('/', 0, lastSlashIndex - 1);
      foldername = currpath[nextToLastSlashIndex+1:lastSlashIndex];
      if (foldername.find(Util.getTypeFoldername('AdditionalTrustManagerAttrs')) > -1):
        attName = 'additionalTrustManagerAttrs';
      propertObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole, attName);
      if (propertyObject == 0):
        if currole == "WebSphereManagementScopeRef":
          ManagementScopeRef.create(objid, curjsonobject, "managementScope");

  Util.popPathElement('TrustManager');
