from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('UDPInboundChannel')

  name = Util.getRequiredAttribute(objid, "name", 'UDPInboundChannel');

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereUDPInboundChannel");
  exportedObject.put("roleName", "WebSphereUDPInboundChannel");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.udpinboundchannel.addressincludelist", objid, "addressIncludeList","UDPInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.udpinboundchannel.endpointname", objid, "endPointName","UDPInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.udpinboundchannel.name", objid, "name","UDPInboundChannel");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.udpinboundchannel.discriminationweight", objid, "discriminationWeight","UDPInboundChannel");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.udpinboundchannel.addressexcludelist", objid, "addressExcludeList","UDPInboundChannel");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"UDPInboundChannel");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('UDPInboundChannel');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('UDPInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("UDPInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addPathProperty(properties, "addressIncludeList", roleProperties.optString("websphere.udpinboundchannel.addressincludelist", None));
  Util.addIfNotNone(properties, "endPointName", roleProperties.optString("websphere.udpinboundchannel.endpointname", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.udpinboundchannel.name", None));
  Util.addIfNotNone(properties, "discriminationWeight", roleProperties.optString("websphere.udpinboundchannel.discriminationweight", None));
  Util.addPathProperty(properties, "addressExcludeList", roleProperties.optString("websphere.udpinboundchannel.addressexcludelist", None));
  print "Creating UDPInboundChannel with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("UDPInboundChannel", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('UDPInboundChannel');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('UDPInboundChannel')
  if not jsonobject.has("roleProperties"):
    raise Exception("UDPInboundChannel resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.udpinboundchannel.addressincludelist", None), "addressIncludeList","UDPInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.udpinboundchannel.endpointname", None), "endPointName","UDPInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.udpinboundchannel.name", None), "name","UDPInboundChannel");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.udpinboundchannel.discriminationweight", None), "discriminationWeight","UDPInboundChannel");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.udpinboundchannel.addressexcludelist", None), "addressExcludeList","UDPInboundChannel");
  if len(atts) != 0:
    print "Modifying UDPInboundChannel with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "UDPInboundChannel configuration up to date.";

  Property.removeProperties(objid, 'properties',"UDPInboundChannel");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('UDPInboundChannel');
