from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WSGWGatewayService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWSGWGatewayService");
  exportedObject.put("roleName", "WebSphereWSGWGatewayService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwgatewayservice.name", objid, "name","WSGWGatewayService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwgatewayservice.defaulttargetname", objid, "defaultTargetName","WSGWGatewayService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwgatewayservice.replydestinationname", objid, "replyDestinationName","WSGWGatewayService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwgatewayservice.description", objid, "description","WSGWGatewayService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwgatewayservice.requestdestinationname", objid, "requestDestinationName","WSGWGatewayService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wsgwgatewayservice.inboundservicename", objid, "inboundServiceName","WSGWGatewayService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WSGWGatewayService');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WSGWGatewayService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWGatewayService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.wsgwgatewayservice.name", None));
  Util.addIfNotNone(properties, "defaultTargetName", roleProperties.optString("websphere.wsgwgatewayservice.defaulttargetname", None));
  Util.addIfNotNone(properties, "replyDestinationName", roleProperties.optString("websphere.wsgwgatewayservice.replydestinationname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.wsgwgatewayservice.description", None));
  Util.addIfNotNone(properties, "requestDestinationName", roleProperties.optString("websphere.wsgwgatewayservice.requestdestinationname", None));
  Util.addIfNotNone(properties, "inboundServiceName", roleProperties.optString("websphere.wsgwgatewayservice.inboundservicename", None));
  print "Creating WSGWGatewayService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WSGWGatewayService", parentid, properties);
  Util.popPathElement('WSGWGatewayService');

def update(objid,jsonobject):
  Util.pushPathElement('WSGWGatewayService')
  if not jsonobject.has("roleProperties"):
    raise Exception("WSGWGatewayService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwgatewayservice.name", None), "name","WSGWGatewayService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwgatewayservice.defaulttargetname", None), "defaultTargetName","WSGWGatewayService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwgatewayservice.replydestinationname", None), "replyDestinationName","WSGWGatewayService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwgatewayservice.description", None), "description","WSGWGatewayService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwgatewayservice.requestdestinationname", None), "requestDestinationName","WSGWGatewayService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wsgwgatewayservice.inboundservicename", None), "inboundServiceName","WSGWGatewayService");
  if len(atts) != 0:
    print "Modifying WSGWGatewayService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WSGWGatewayService configuration up to date.";

  Util.popPathElement('WSGWGatewayService');
