from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from GSCMemberEndpoint import GSCMemberEndpoint

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('GenericServerClusterTimeMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereGenericServerClusterTimeMapping");
  exportedObject.put("roleName", "WebSphereGenericServerClusterTimeMapping");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverclustertimemapping.endtime", objid, "endTime","GenericServerClusterTimeMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverclustertimemapping.starttime", objid, "startTime","GenericServerClusterTimeMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.genericserverclustertimemapping.action", objid, "action","GenericServerClusterTimeMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  gscMemberEndpoints = Util.parseConfigIdListAttribute(objid, 'gscMemberEndpoints',"GenericServerClusterTimeMapping");
  for gscMemberEndpoint in gscMemberEndpoints:
    if len(gscMemberEndpoint) > 0:
      returndict = Util.createTypeFolder(respath, "GSCMemberEndpoint", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, GSCMemberEndpoint._export(gscMemberEndpoint, currespath, "GSC Member Endpoint%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('GenericServerClusterTimeMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('GenericServerClusterTimeMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerClusterTimeMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "endTime", roleProperties.optString("websphere.genericserverclustertimemapping.endtime", None));
  Util.addIfNotNone(properties, "startTime", roleProperties.optString("websphere.genericserverclustertimemapping.starttime", None));
  Util.addIfNotNone(properties, "action", roleProperties.optString("websphere.genericserverclustertimemapping.action", None));
  print "Creating GenericServerClusterTimeMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("GenericServerClusterTimeMapping", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereGSCMemberEndpoint":
        GSCMemberEndpoint.create(objid, curjsonobject);
  Util.popPathElement('GenericServerClusterTimeMapping');

def update(objid,jsonobject):
  Util.pushPathElement('GenericServerClusterTimeMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("GenericServerClusterTimeMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverclustertimemapping.endtime", None), "endTime","GenericServerClusterTimeMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverclustertimemapping.starttime", None), "startTime","GenericServerClusterTimeMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.genericserverclustertimemapping.action", None), "action","GenericServerClusterTimeMapping");
  if len(atts) != 0:
    print "Modifying GenericServerClusterTimeMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "GenericServerClusterTimeMapping configuration up to date.";

  gscMemberEndpoints = Util.parseConfigIdListAttribute(objid, 'gscMemberEndpoints',"GenericServerClusterTimeMapping");
  for gscMemberEndpoint in gscMemberEndpoints:
    if len(gscMemberEndpoint) > 0:
      Util.remove(gscMemberEndpoint);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereGSCMemberEndpoint":
        GSCMemberEndpoint.create(objid, curjsonobject);

  Util.popPathElement('GenericServerClusterTimeMapping');
