from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBTopicSpaceAudit')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBTopicSpaceAudit");
  exportedObject.put("roleName", "WebSphereSIBTopicSpaceAudit");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspaceaudit.identifier", objid, "identifier","SIBTopicSpaceAudit");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibtopicspaceaudit.allowaudit", objid, "allowAudit","SIBTopicSpaceAudit");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBTopicSpaceAudit');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBTopicSpaceAudit')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceAudit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibtopicspaceaudit.identifier", None));
  Util.addIfNotNone(properties, "allowAudit", roleProperties.optString("websphere.sibtopicspaceaudit.allowaudit", None));
  print "Creating SIBTopicSpaceAudit with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBTopicSpaceAudit", parentid, properties);
  Util.popPathElement('SIBTopicSpaceAudit');

def update(objid,jsonobject):
  Util.pushPathElement('SIBTopicSpaceAudit')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBTopicSpaceAudit resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspaceaudit.identifier", None), "identifier","SIBTopicSpaceAudit");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibtopicspaceaudit.allowaudit", None), "allowAudit","SIBTopicSpaceAudit");
  if len(atts) != 0:
    print "Modifying SIBTopicSpaceAudit with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBTopicSpaceAudit configuration up to date.";

  Util.popPathElement('SIBTopicSpaceAudit');
