from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('StatefulSessionBeanConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStatefulSessionBeanConfig");
  exportedObject.put("roleName", "WebSphereStatefulSessionBeanConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.statefulsessionbeanconfig.ejbname", objid, "ejbName","StatefulSessionBeanConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.statefulsessionbeanconfig.timeout", objid, "timeout","StatefulSessionBeanConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StatefulSessionBeanConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('StatefulSessionBeanConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("StatefulSessionBeanConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "ejbName", roleProperties.optString("websphere.statefulsessionbeanconfig.ejbname", None));
  Util.addIfNotNone(properties, "timeout", roleProperties.optString("websphere.statefulsessionbeanconfig.timeout", None));
  print "Creating StatefulSessionBeanConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StatefulSessionBeanConfig", parentid, properties);
  Util.popPathElement('StatefulSessionBeanConfig');

def update(objid,jsonobject):
  Util.pushPathElement('StatefulSessionBeanConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("StatefulSessionBeanConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.statefulsessionbeanconfig.ejbname", None), "ejbName","StatefulSessionBeanConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.statefulsessionbeanconfig.timeout", None), "timeout","StatefulSessionBeanConfig");
  if len(atts) != 0:
    print "Modifying StatefulSessionBeanConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StatefulSessionBeanConfig configuration up to date.";

  Util.popPathElement('StatefulSessionBeanConfig');
