from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WARFragmentFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWARFragmentFile");
  exportedObject.put("roleName", "WebSphereWARFragmentFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfragmentfile.lastmodified", objid, "lastModified","WARFragmentFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfragmentfile.originaluri", objid, "originalURI","WARFragmentFile");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.warfragmentfile.types", objid, "types","WARFragmentFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfragmentfile.directoryentry", objid, "directoryEntry","WARFragmentFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfragmentfile.uri", objid, "URI","WARFragmentFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.warfragmentfile.size", objid, "size","WARFragmentFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "WARFragmentFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WARFragmentFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WARFragmentFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("WARFragmentFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.warfragmentfile.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.warfragmentfile.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.warfragmentfile.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.warfragmentfile.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.warfragmentfile.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.warfragmentfile.size", None));
  print "Creating WARFragmentFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WARFragmentFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WARFragmentFile');

def update(objid,jsonobject):
  Util.pushPathElement('WARFragmentFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("WARFragmentFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfragmentfile.lastmodified", None), "lastModified","WARFragmentFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfragmentfile.originaluri", None), "originalURI","WARFragmentFile");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.warfragmentfile.types", None), "types","WARFragmentFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfragmentfile.directoryentry", None), "directoryEntry","WARFragmentFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfragmentfile.uri", None), "URI","WARFragmentFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.warfragmentfile.size", None), "size","WARFragmentFile");
  if len(atts) != 0:
    print "Modifying WARFragmentFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WARFragmentFile configuration up to date.";

  File.removeFiles(objid, 'files',"WARFragmentFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('WARFragmentFile');
