#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from InjectionTarget import InjectionTarget

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EnvEntry')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEnvEntry");
  exportedObject.put("roleName", "WebSphereEnvEntry");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.enventry.name", objid, "name","EnvEntry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.enventry.type", objid, "type","EnvEntry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.enventry.mappedname", objid, "mappedName","EnvEntry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.enventry.lookupname", objid, "lookupName","EnvEntry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.enventry.description", objid, "description","EnvEntry");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.enventry.value", objid, "value","EnvEntry");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'EnvEntry');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'EnvEntry');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      returndict = Util.createTypeFolder(respath, "InjectionTarget", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      injName = Util.getOptionalAttribute(injTarget, "injectionTargetName", "InjectionTarget");
      if injName is not None and len(injName) > 0:
        resourceName = injName;
      else:
        resourceName = "InjectionTarget%s" % i;
      Util.addAllFromExport(extraObjects, InjectionTarget._export(injTarget, currespath, resourceName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EnvEntry');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('EnvEntry')
  if not jsonobject.has("roleProperties"):
    raise Exception("EnvEntry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.enventry.name", None));
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.enventry.type", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.enventry.mappedname", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.enventry.lookupname", ""));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.enventry.description", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.enventry.value", None));
  print "Creating EnvEntry with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EnvEntry", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('EnvEntry');

def update(objid,jsonobject):
  Util.pushPathElement('EnvEntry')
  if not jsonobject.has("roleProperties"):
    raise Exception("EnvEntry resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.enventry.name", None), "name","EnvEntry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.enventry.type", None), "type","EnvEntry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.enventry.mappedname", None), "mappedName","EnvEntry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.enventry.lookupname", ""), "lookupName","EnvEntry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.enventry.description", None), "description","EnvEntry");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.enventry.value", None), "value","EnvEntry");
  if len(atts) != 0:
    print "Modifying EnvEntry with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EnvEntry configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'EnvEntry');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  injectionTargets = Util.parseConfigIdListAttribute(objid, 'injectionTargets', 'EnvEntry');
  for injTarget in injectionTargets:
    if len(injTarget) > 0:
      Util.remove(injTarget);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereInjectionTarget":
        InjectionTarget.create(objid, curjsonobject);
  Util.popPathElement('EnvEntry');
