from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('InstallTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereInstallTarget");
  exportedObject.put("roleName", "WebSphereInstallTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.installtarget.platform", objid, "platform","InstallTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.installtarget.hostname", objid, "hostname","InstallTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.installtarget.sshpublickeyinstalled", objid, "sshPublicKeyInstalled","InstallTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.installtarget.password", objid, "password","InstallTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.installtarget.username", objid, "username","InstallTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('InstallTarget');
  return result;



def create(parentid, jsonobject):
  if not Util.isValidType("InstallTarget", 1):
    return;
  Util.pushPathElement('InstallTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("InstallTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "platform", roleProperties.optString("websphere.installtarget.platform", None));
  Util.addIfNotNone(properties, "hostname", roleProperties.optString("websphere.installtarget.hostname", None));
  Util.addIfNotNone(properties, "sshPublicKeyInstalled", roleProperties.optString("websphere.installtarget.sshpublickeyinstalled", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.installtarget.password", None));
  Util.addIfNotNone(properties, "username", roleProperties.optString("websphere.installtarget.username", None));
  print "Creating InstallTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("InstallTarget", parentid, properties);
  Util.popPathElement('InstallTarget');

def update(objid,jsonobject):
  Util.pushPathElement('InstallTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("InstallTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.installtarget.platform", None), "platform","InstallTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.installtarget.hostname", None), "hostname","InstallTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.installtarget.sshpublickeyinstalled", None), "sshPublicKeyInstalled","InstallTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.installtarget.password", None), "password","InstallTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.installtarget.username", None), "username","InstallTarget");
  if len(atts) != 0:
    print "Modifying InstallTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "InstallTarget configuration up to date.";

  Util.popPathElement('InstallTarget');
