from org.codehaus.jettison.json import JSONObject, JSONArray
from utilities import Util
from SecureSessionCookie import SecureSessionCookie

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "SessionSecurity";

  containmentpath = "%(parentconpath)sSessionSecurity:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SessionSecurity')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSessionSecurity");
  exportedObject.put("roleName", "WebSphereSessionSecurity");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  
  i = 0;
  secureSessionCookies = Util.parseConfigIdListAttribute(objid, 'secureSessionCookie',"SessionSecurity");
  for secureSessionCookie in secureSessionCookies:
    if len(secureSessionCookie) > 0:
      returndict = Util.createTypeFolder(respath, "SecureSessionCookie", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, SecureSessionCookie._export(secureSessionCookie, currespath, "SecureSessionCookie%s" % i));
      i = i + 1;
  
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SessionSecurity');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("SessionSecurity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  
  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create SessionSecurity on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;

def create(parentid, jsonobject):
  Util.pushPathElement('SessionSecurity')
  if not jsonobject.has("roleProperties"):
    raise Exception("SessionSecurity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating SessionSecurity with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SessionSecurity", parentid, properties);
  
  secureSessionCookies = Util.parseConfigIdListAttribute(objid, 'secureSessionCookie',"SessionSecurity");
  for secureSessionCookie in secureSessionCookies:
    if len(secureSessionCookie) > 0:
      Util.remove(secureSessionCookie);
  
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSecureSessionCookie":
        SecureSessionCookie.create(objid, curjsonobject);
  Util.popPathElement('SessionSecurity');
  return objid;
  

def update(objid,jsonobject):
  Util.pushPathElement('SessionSecurity')
  if not jsonobject.has("roleProperties"):
    raise Exception("SessionSecurity resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying SessionSecurity with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SessionSecurity configuration up to date.";
    
  secureSessionCookies = Util.parseConfigIdListAttribute(objid, 'secureSessionCookie',"SessionSecurity");
  for secureSessionCookie in secureSessionCookies:
    if len(secureSessionCookie) > 0:
      Util.remove(secureSessionCookie);
  
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSecureSessionCookie":
        SecureSessionCookie.create(objid, curjsonobject);
  

  Util.popPathElement('SessionSecurity');
