from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASDataSourceDefinitionBinding')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASDataSourceDefinitionBinding");
  exportedObject.put("roleName", "WebSphereWASDataSourceDefinitionBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasdatasourcedefinitionbinding.jndiname", objid, "jndiName","WASDataSourceDefinitionBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASDataSourceDefinitionBinding');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASDataSourceDefinitionBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASDataSourceDefinitionBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.wasdatasourcedefinitionbinding.jndiname", None));
  print "Creating WASDataSourceDefinitionBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASDataSourceDefinitionBinding", parentid, properties);
  Util.popPathElement('WASDataSourceDefinitionBinding');

def update(objid,jsonobject):
  Util.pushPathElement('WASDataSourceDefinitionBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASDataSourceDefinitionBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasdatasourcedefinitionbinding.jndiname", None), "jndiName","WASDataSourceDefinitionBinding");
  if len(atts) != 0:
    print "Modifying WASDataSourceDefinitionBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASDataSourceDefinitionBinding configuration up to date.";

  Util.popPathElement('WASDataSourceDefinitionBinding');
