from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.KeyStore')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonbnd.KeyStore");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonbnd.KeyStore");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.keystore.type", objid, "type","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.keystore.keystoreref", objid, "KeyStoreRef","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.keystore.path", objid, "path","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.keystore.storepass", objid, "storepass","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.KeyStore');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.KeyStore')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.KeyStore resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.type", None));
  Util.addIfNotNone(properties, "KeyStoreRef", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.keystoreref", None));
  Util.addIfNotNone(properties, "path", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.path", None));
  Util.addIfNotNone(properties, "storepass", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.storepass", None));
  print "Creating com.ibm.etools.webservice.wscommonbnd.KeyStore with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonbnd.KeyStore", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.KeyStore');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.KeyStore')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.KeyStore resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.type", None), "type","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.keystoreref", None), "KeyStoreRef","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.path", None), "path","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.keystore.storepass", None), "storepass","com.ibm.etools.webservice.wscommonbnd.KeyStore");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonbnd.KeyStore with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonbnd.KeyStore configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.KeyStore');
