from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SSLConfigRef import SSLConfigRef
from ManagementScopeRef import ManagementScopeRef

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DynamicSSLConfigSelection')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDynamicSSLConfigSelection");
  exportedObject.put("roleName", "WebSphereDynamicSSLConfigSelection");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicsslconfigselection.name", objid, "name","DynamicSSLConfigSelection");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicsslconfigselection.description", objid, "description","DynamicSSLConfigSelection");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicsslconfigselection.dynamicselectioninfo", objid, "dynamicSelectionInfo","DynamicSSLConfigSelection");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.dynamicsslconfigselection.certificatealias", objid, "certificateAlias","DynamicSSLConfigSelection");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  sslConfig = Util.getOptionalAttribute(objid, 'sslConfig', 'DynamicSSLConfigSelection');
  if sslConfig is not None and len(sslConfig) > 0:
    returndict = Util.createTypeFolder(respath, "SSLConfigRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SSLConfigRef._export(sslConfig, currespath, "SSLConfig"));

  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'DynamicSSLConfigSelection');
  if managementScope is not None and len(managementScope) > 0:
    returndict = Util.createTypeFolder(respath, "ManagementScopeRef", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ManagementScopeRef._export(managementScope, currespath, "ManagementScope"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DynamicSSLConfigSelection');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DynamicSSLConfigSelection')
  if not jsonobject.has("roleProperties"):
    raise Exception("DynamicSSLConfigSelection resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.dynamicsslconfigselection.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.dynamicsslconfigselection.description", None));
  Util.addIfNotNone(properties, "dynamicSelectionInfo", roleProperties.optString("websphere.dynamicsslconfigselection.dynamicselectioninfo", None));
  Util.addIfNotNone(properties, "certificateAlias", roleProperties.optString("websphere.dynamicsslconfigselection.certificatealias", None));
  print "Creating DynamicSSLConfigSelection with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DynamicSSLConfigSelection", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "sslConfig");
      elif currole == "WebSphereManagementScopeRef":
        ManagementScopeRef.create(objid, curjsonobject, "managementScope");
  Util.popPathElement('DynamicSSLConfigSelection');

def update(objid,jsonobject):
  Util.pushPathElement('DynamicSSLConfigSelection')
  if not jsonobject.has("roleProperties"):
    raise Exception("DynamicSSLConfigSelection resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicsslconfigselection.name", None), "name","DynamicSSLConfigSelection");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicsslconfigselection.description", None), "description","DynamicSSLConfigSelection");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicsslconfigselection.dynamicselectioninfo", None), "dynamicSelectionInfo","DynamicSSLConfigSelection");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.dynamicsslconfigselection.certificatealias", None), "certificateAlias","DynamicSSLConfigSelection");
  if len(atts) != 0:
    print "Modifying DynamicSSLConfigSelection with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DynamicSSLConfigSelection configuration up to date.";

  Util.unsetAttribute(objid, "sslConfig", "DynamicSSLConfigSelection");

  Util.unsetAttribute(objid, "managementScope", "DynamicSSLConfigSelection");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereSSLConfigRef":
        SSLConfigRef.create(objid, curjsonobject, "sslConfig");
      elif currole == "WebSphereManagementScopeRef":
        ManagementScopeRef.create(objid, curjsonobject, "managementScope");
  Util.popPathElement('DynamicSSLConfigSelection');
