from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.extendedrepositoryservice.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'ExtendedRepositoryService');

  containmentpath = "%(parentconpath)sExtendedRepositoryService:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('ExtendedRepositoryService')

  name = Util.getRequiredAttribute(objid, "name", 'ExtendedRepositoryService');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereExtendedRepositoryService");
  exportedObject.put("roleName", "WebSphereExtendedRepositoryService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extendedrepositoryservice.name", objid, "name","ExtendedRepositoryService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extendedrepositoryservice.autocheckpointsenabled", objid, "autoCheckpointsEnabled","ExtendedRepositoryService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extendedrepositoryservice.autocheckpointsdepth", objid, "autoCheckpointsDepth","ExtendedRepositoryService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.extendedrepositoryservice.checkpointroot", objid, "checkpointRoot","ExtendedRepositoryService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ExtendedRepositoryService');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtendedRepositoryService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.extendedrepositoryservice.name"):
    raise Exception("Resource role properties does not contain websphere.extendedrepositoryservice.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ExtendedRepositoryService on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('ExtendedRepositoryService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtendedRepositoryService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.extendedrepositoryservice.name"):
    raise Exception("Resource role properties does not contain websphere.extendedrepositoryservice.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.extendedrepositoryservice.name", None));
  Util.addIfNotNone(properties, "autoCheckpointsEnabled", roleProperties.optString("websphere.extendedrepositoryservice.autocheckpointsenabled", None));
  Util.addIfNotNone(properties, "autoCheckpointsDepth", roleProperties.optString("websphere.extendedrepositoryservice.autocheckpointsdepth", None));
  Util.addIfNotNone(properties, "checkpointRoot", roleProperties.optString("websphere.extendedrepositoryservice.checkpointroot", None));
  print "Creating ExtendedRepositoryService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ExtendedRepositoryService", parentid, properties);
  Util.popPathElement('ExtendedRepositoryService');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ExtendedRepositoryService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ExtendedRepositoryService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.extendedrepositoryservice.name"):
    raise Exception("Resource role properties does not contain websphere.extendedrepositoryservice.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extendedrepositoryservice.name", None), "name","ExtendedRepositoryService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extendedrepositoryservice.autocheckpointsenabled", None), "autoCheckpointsEnabled","ExtendedRepositoryService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extendedrepositoryservice.autocheckpointsdepth", None), "autoCheckpointsDepth","ExtendedRepositoryService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.extendedrepositoryservice.checkpointroot", None), "checkpointRoot","ExtendedRepositoryService");
  if len(atts) != 0:
    print "Modifying ExtendedRepositoryService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ExtendedRepositoryService configuration up to date.";

  Util.popPathElement('ExtendedRepositoryService');
