from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JAASAuthData')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJAASAuthData");
  exportedObject.put("roleName", "WebSphereJAASAuthData");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaasauthdata.password", objid, "password","JAASAuthData");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaasauthdata.userid", objid, "userId","JAASAuthData");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaasauthdata.alias", objid, "alias","JAASAuthData");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.jaasauthdata.description", objid, "description","JAASAuthData");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JAASAuthData');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('JAASAuthData')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAASAuthData resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.jaasauthdata.password", None));
  Util.addIfNotNone(properties, "userId", roleProperties.optString("websphere.jaasauthdata.userid", None));
  Util.addIfNotNone(properties, "alias", roleProperties.optString("websphere.jaasauthdata.alias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.jaasauthdata.description", None));
  print "Creating JAASAuthData with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JAASAuthData", parentid, properties);
  Util.popPathElement('JAASAuthData');

def update(objid,jsonobject):
  Util.pushPathElement('JAASAuthData')
  if not jsonobject.has("roleProperties"):
    raise Exception("JAASAuthData resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaasauthdata.password", None), "password","JAASAuthData");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaasauthdata.userid", None), "userId","JAASAuthData");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaasauthdata.alias", None), "alias","JAASAuthData");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.jaasauthdata.description", None), "description","JAASAuthData");
  if len(atts) != 0:
    print "Modifying JAASAuthData with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JAASAuthData configuration up to date.";

  Util.popPathElement('JAASAuthData');
