from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ManagementScope')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereManagementScope");
  exportedObject.put("roleName", "WebSphereManagementScope");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managementscope.scopename", objid, "scopeName","ManagementScope");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.managementscope.scopetype", objid, "scopeType","ManagementScope");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ManagementScope');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ManagementScope')
  if not jsonobject.has("roleProperties"):
    raise Exception("ManagementScope resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "scopeName", roleProperties.optString("websphere.managementscope.scopename", None));
  Util.addIfNotNone(properties, "scopeType", roleProperties.optString("websphere.managementscope.scopetype", None));
  print "Creating ManagementScope with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ManagementScope", parentid, properties);
  Util.popPathElement('ManagementScope');

def update(objid,jsonobject):
  Util.pushPathElement('ManagementScope')
  if not jsonobject.has("roleProperties"):
    raise Exception("ManagementScope resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managementscope.scopename", None), "scopeName","ManagementScope");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.managementscope.scopetype", None), "scopeType","ManagementScope");
  if len(atts) != 0:
    print "Modifying ManagementScope with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ManagementScope configuration up to date.";

  Util.popPathElement('ManagementScope');
