#- Licensed Materials - Property of IBM Corp.
#- IBM UrbanCode Deploy
#- (c) Copyright IBM Corporation 2014, 2015. All Rights Reserved.
#-
#- U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
#- GSA ADP Schedule Contract with IBM Corp.

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Description import Description
from DisplayName import DisplayName
from IconType import IconType

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageDestination')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageDestination");
  exportedObject.put("roleName", "WebSphereMessageDestination");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestination.name", objid, "name","MessageDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestination.lookupname", objid, "lookupName","MessageDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestination.largeicon", objid, "largeIcon","MessageDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestination.smallicon", objid, "smallIcon","MessageDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestination.displayname", objid, "displayName","MessageDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestination.description", objid, "description","MessageDestination");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagedestination.mappedname", objid, "mappedName","MessageDestination");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'MessageDestination');
  for description in descriptions:
    if len(description) > 0:
      returndict = Util.createTypeFolder(respath, "Description", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, Description._export(description, currespath, "Description%s" % i));
      i = i + 1;

  i = 0;
  displayNames = Util.parseConfigIdListAttribute(objid, 'displayNames', 'MessageDestination');
  for displayName in displayNames:
    if len(displayName) > 0:
      returndict = Util.createTypeFolder(respath, "DisplayName", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DisplayName._export(displayName, currespath, "DisplayName%s" % i));
      i = i + 1;

  i = 0;
  icons = Util.parseConfigIdListAttribute(objid, 'icons', 'MessageDestination');
  for icon in icons:
    if len(icon) > 0:
      returndict = Util.createTypeFolder(respath, "IconType", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, IconType._export(icon, currespath, "Icon%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageDestination');
  return result;


def create(parentid, jsonobject):
  Util.pushPathElement('MessageDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.messagedestination.name", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.messagedestination.lookupname", ""));
  Util.addIfNotNone(properties, "largeIcon", roleProperties.optString("websphere.messagedestination.largeicon", None));
  Util.addIfNotNone(properties, "smallIcon", roleProperties.optString("websphere.messagedestination.smallicon", None));
  Util.addIfNotNone(properties, "displayName", roleProperties.optString("websphere.messagedestination.displayname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.messagedestination.description", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.messagedestination.mappedname", None));
  print "Creating MessageDestination with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageDestination", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereDisplayName":
        DisplayName.create(objid, curjsonobject);
      elif currole == "WebSphereIconType":
        IconType.create(objid, curjsonobject);
  Util.popPathElement('MessageDestination');


def update(objid,jsonobject):
  Util.pushPathElement('MessageDestination')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageDestination resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestination.name", None), "name","MessageDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestination.lookupname", ""), "lookupName","MessageDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestination.largeicon", None), "largeIcon","MessageDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestination.smallicon", None), "smallIcon","MessageDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestination.displayname", None), "displayName","MessageDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestination.description", None), "description","MessageDestination");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagedestination.mappedname", None), "mappedName","MessageDestination");
  if len(atts) != 0:
    print "Modifying MessageDestination with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageDestination configuration up to date.";

  descriptions = Util.parseConfigIdListAttribute(objid, 'descriptions', 'MessageDestination');
  for description in descriptions:
    if len(description) > 0:
      Util.remove(description);

  displayNames = Util.parseConfigIdListAttribute(objid, 'displayNames', 'MessageDestination');
  for displayName in displayNames:
    if len(displayName) > 0:
      Util.remove(displayName);

  icons = Util.parseConfigIdListAttribute(objid, 'icons', 'MessageDestination');
  for icon in icons:
    if len(icon) > 0:
      Util.remove(icon);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereDescription":
        Description.create(objid, curjsonobject);
      elif currole == "WebSphereDisplayName":
        DisplayName.create(objid, curjsonobject);
      elif currole == "WebSphereIconType":
        IconType.create(objid, curjsonobject);
  Util.popPathElement('MessageDestination');
