from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASMessageDestinationRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASMessageDestinationRef");
  exportedObject.put("roleName", "WebSphereWASMessageDestinationRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasmessagedestinationref.type", objid, "type","WASMessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasmessagedestinationref.mappedname", objid, "mappedName","WASMessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasmessagedestinationref.lookupname", objid, "lookupName","WASMessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasmessagedestinationref.link", objid, "link","WASMessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasmessagedestinationref.usage", objid, "usage","WASMessageDestinationRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasmessagedestinationref.refname", objid, "refName","WASMessageDestinationRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASMessageDestinationRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASMessageDestinationRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASMessageDestinationRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "type", roleProperties.optString("websphere.wasmessagedestinationref.type", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.wasmessagedestinationref.mappedname", None));
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.wasmessagedestinationref.lookupname", None));
  Util.addIfNotNone(properties, "link", roleProperties.optString("websphere.wasmessagedestinationref.link", None));
  Util.addIfNotNone(properties, "usage", roleProperties.optString("websphere.wasmessagedestinationref.usage", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.wasmessagedestinationref.refname", None));
  print "Creating WASMessageDestinationRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASMessageDestinationRef", parentid, properties);
  Util.popPathElement('WASMessageDestinationRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASMessageDestinationRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASMessageDestinationRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasmessagedestinationref.type", None), "type","WASMessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasmessagedestinationref.mappedname", None), "mappedName","WASMessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasmessagedestinationref.lookupname", None), "lookupName","WASMessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasmessagedestinationref.link", None), "link","WASMessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasmessagedestinationref.usage", None), "usage","WASMessageDestinationRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasmessagedestinationref.refname", None), "refName","WASMessageDestinationRef");
  if len(atts) != 0:
    print "Modifying WASMessageDestinationRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASMessageDestinationRef configuration up to date.";

  Util.popPathElement('WASMessageDestinationRef');
